<?php
defined('BASEPATH') OR exit('No direct script access allowed');
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: Content-Type, Content-Length, Accept-Encoding");
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method, Authorization");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");

class Dashboard extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->helper('url');
		$this->load->library('session');
		$this->load->model('api_model');
		$this->load->helper(array('url', 'html'));
		date_default_timezone_set('Asia/Jakarta');
	}

	public function index()
	{
		if(isset($_SESSION['user_name'] ) != null || isset($_SESSION['user_branch'] ) != null){
			redirect('Dashboard/Admin', 'refresh');
		}else{
			$this->load->view('Pages/login');
		}
	}

	private function check_auth(){
		if(isset($_SESSION['user_name']) == null){
			redirect('Dashboard', 'refresh');
		}
	}

	public function Admin(){
		$this->check_auth();
		
		$total_billing['total_billing'] = $this->api_model->total_billing();
		$total_cafe['total_cafe'] = $this->api_model->total_cafe();
		$total_transaction['total_transaction'] = $total_billing['total_billing'][0]['total_billing'] + $total_cafe['total_cafe'][0]['total_cafe'];
		$table_live['table_live'] = $this->api_model->table_live();
		$total_this_month['total_this_month'] = $this->api_model->total_this_month();
		$total_last_month['total_last_month'] = $this->api_model->total_last_month();
		$general['general'] = $this->api_model->general();
		$data['data'] = array_merge($total_transaction, $total_billing, $total_cafe, $table_live, $general, $total_this_month, $total_last_month);
		$this->load->view('Pages/dashboard', $data);
	}

}

?>