<!doctype html>
    <html lang="en">

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
        <meta name="theme-color" content="#000000">
        <title>Elluna Report Online</title>
        <link rel="icon" type="image/png" href="<?php echo base_url() ?>assets/img/logo.png" sizes="32x32">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo base_url() ?>assets/img/logo.png">
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/css/style.css">
        <link rel="manifest" href="<?php echo base_url() ?>dist/manifest.json">
    </head>

    <body>

        <!-- loader -->
        <div id="loader">
            <img src="<?php echo base_url() ?>assets/img/loading-icon.png" alt="icon" class="loading-icon">
        </div>
        <!-- * loader -->

        <!-- App Header -->
        <div class="appHeader no-border transparent position-absolute">
            <div class="pageTitle"></div>
            <div class="right">
            </div>
        </div>
        <!-- * App Header -->

        <!-- App Capsule -->
        <div id="appCapsule">

            <div class="section mt-2 text-center">
                <img src="<?php echo base_url() ?>assets/img/logo.png" style="width: 30%; margin-bottom:20px ;">
                <h1>Log in</h1>
                <h4>Elluna Report Online</h4>
            </div>
            <div class="section mb-5 p-2">

                <div class="card">
                    <div class="card-body pb-1">

                        <div class="form-group basic animated">
                            <div class="input-wrapper">
                                <label class="label" for="userid2">User Name</label>
                                <input type="text" class="form-control" id="username" placeholder="Username">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group basic animated">
                            <div class="input-wrapper">
                                <label class="label" for="userid2">Password</label>
                                <input type="password" class="form-control" id="password" placeholder="Password">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        
                    </div>
                </div>

                <div class="form-button-group  transparent">
                    <button id="login" class="btn btn-primary btn-block btn-lg">Log in</button>
                </div>
            </div>

        </div>
        <!-- * App Capsule -->

        <!-- ========= JS Files =========  -->
        <!-- Bootstrap -->
        <script src="<?php echo base_url() ?>assets/js/lib/bootstrap.bundle.min.js"></script>
        <!-- Ionicons -->
        <!-- Splide -->
        <script src="<?php echo base_url() ?>assets/js/plugins/splide/splide.min.js"></script>
        <!-- Base Js File -->
        <script src="<?php echo base_url() ?>assets/js/base.js"></script>

        <script src="<?php echo base_url(); ?>assets/js/plugins/jquery/jquery.min.js"></script>
        <!-- Bootstrap 4 -->

        <script src="<?php echo base_url(); ?>assets/js/dist/js/sweetalert2.min.js"></script>

        <script type="text/javascript">
          $(document).ready(function() {
              $('#login').click(function(e){
                e.preventDefault();
                var username = $("#username").val();
                var password = $("#password").val();
                $.ajax({
                    type: "POST",
                    url: "<?php echo base_url(); ?>Auth/processlogin",
                    dataType: "json",
                    data: {
                        username:username,  
                        password:password
                    },
                    success : function(data){
                        if (data.code == "200"){
                         window.location.replace("<?php echo base_url(); ?>dashboard");
                     } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: data.msg
                        })
                    }
                }
            });
            });
          });
      </script>

  </body>

  </html>