<?php 
define('DOC_ROOT_PATH', $_SERVER['DOCUMENT_ROOT'].'/');
require DOC_ROOT_PATH . $this->config->item('header');
?>

    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">

        </div>
        <div class="pageTitle">
            Moscow Laporan Online
        </div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->


    <!-- App Capsule -->
    <div id="appCapsule">


        <!-- Wallet -->
        <div class="section full gradientSection">
            <div class="in">
                <h5 class="title mb-2">Total Transaksi Hari Ini</h5>
                <?php if($data['total_transaction'] != null) { ?>
                    <h1 class="total"><?php echo 'Rp. '.number_format($data['total_transaction'] ); ?></h1>
                <?php }else{ ?>
                    <h1 class="total"><?php echo 'Rp. 0' ; ?></h1>
                <?php } ?>
            </div>
        </div>
        <!-- * Wallet -->

        <!-- Transactions -->
        <div class="section mt-4">
            <div class="section-heading">
                <h2 class="title">Transaksi</h2>
            </div>
            <div class="card">
                <ul class="listview flush transparent no-line image-listview detailed-list mt-1 mb-1">
                    <!-- item -->
                    <li>
                        <a href="#" class="item">
                            <div class="icon-box bg-primary">
                                <ion-icon name="bowling-ball"></ion-icon>
                            </div>
                            <div class="in">
                                <div>
                                    <strong>Billing</strong>
                                </div>
                                <div class="text-end">
                                    <?php foreach($data['total_billing'] as $rowtotalbilling) { ?>
                                        <strong><?php echo 'Rp. '.number_format($rowtotalbilling['total_billing']); ?></strong>
                                    <?php } ?>
                                </div>
                            </div>
                        </a>
                    </li>
                    <!-- * item -->
                    <!-- item -->
                    <li>
                        <a href="#" class="item">
                            <div class="icon-box bg-warning">
                                <ion-icon name="cafe-outline"></ion-icon>
                            </div>
                            <div class="in">
                                <div>
                                    <strong>Cafe</strong>
                                </div>
                                <div class="text-end">
                                    <?php foreach($data['total_cafe'] as $rowtotalcafe) { ?>

                                        <strong> <?php echo 'Rp. '.number_format($rowtotalcafe['total_cafe']); ?></strong>
                                    <?php } ?>
                                </div>
                            </div>
                        </a>
                    </li>
                    <!-- * item -->
                </ul>
            </div>
        </div>
        <!-- Transactions -->


        <!-- Portfolio -->
        <div class="section mt-4">
            <div class="section-heading">
                <h2 class="title">Meja Aktif</h2>
            </div>
            <div class="card">
                <ul class="listview flush transparent image-listview detailed-list mt-1 mb-1">
                    <!-- item -->
                    <?php foreach($data['table_live'] as $row) { ?>
                        <li>
                            <div class="item">
                                <?php if($row['table_active'] == 1){ ?>
                                    <div class="icon-box text-success">
                                    <?php }else{ ?>
                                      <div class="icon-box text-danger">
                                      <?php } ?>
                                      <ion-icon name="power-outline"></ion-icon>
                                  </div>
                                  <div class="in">
                                    <div>
                                        <strong>Meja <?php echo $row['table_number']; ?></strong>
                                        <div class="text-medium text-secondary">
                                            <?php if($row['table_start_time'] != null){ ?>
                                                Mulai: 06:00
                                            <?php }else{ ?>
                                                - 
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <strong>
                                            <?php if($row['table_active'] == 1){ ?>
                                                <span class="text-success">Active</span>
                                            <?php }else{ ?>
                                                <span class="text-danger">Kosong</span>
                                            <?php } ?>
                                        </strong>
                                        <div class="text-medium" style="text-align: center;">
                                            <?php if($row['table_active'] == 1){ ?>
                                                <div class="medium-small"><?php echo $row['table_mode']; ?></div>
                                            <?php }else{ ?>
                                                <div class="medium-small">-</div>
                                            <?php } ?>
                                            Reguler
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    <?php } ?>
                    <!-- * item -->
                    <!-- item -->
                    <!-- * item -->
                </ul>
            </div>
        </div>
        <!-- Portfolio -->

        <div class="section mt-2 mb-4">
            <div class="card">
                <ul class="listview no-line transparent flush simple-listview">
                    <li>
                        <div class="text-muted">Transaksi Bulan Ini</div>
                        <?php foreach($data['total_this_month'] as $rowse) { ?>
                            <strong class="text-success"><?php echo 'Rp. '.number_format($rowse['total_billing']); ?></strong>
                        <?php } ?>
                    </li>
                    <li>
                        <div class="text-muted">Transaksi Bulan Lalu</div>
                        <?php foreach($data['total_last_month'] as $rowsa) { ?>
                            <strong class="text-success"><?php echo 'Rp. '.number_format($rowsa['total_billing']); ?></strong>
                        <?php } ?>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Slider -->
        <div class="section full mt-4 mb-3">
            <div class="carousel-single splide">
                <div class="splide__track">
                    <ul class="splide__list">

                        <li class="splide__slide">
                            <div class="card card-with-icon">
                                <div class="card-body pt-3 pb-3 text-center">
                                    <div class="card-icon bg-success mb-2">
                                        <ion-icon name="cloud-download-outline"></ion-icon>
                                    </div>
                                    <h3 class="card-titlde mb-1">Download Stock</h3>
                                    <p>Download Stock Cafe</p>
                                    <div class="row">
                                        <div class="col">
                                            <a href="#" class="btn btn-secondary">
                                                <ion-icon name="document-outline"></ion-icon>
                                                Dwonload Disini
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li class="splide__slide">
                            <div class="card card-with-icon">
                                <div class="card-body pt-3 pb-3 text-center">
                                    <div class="card-icon bg-info mb-2">
                                        <ion-icon name="person-add-outline"></ion-icon>
                                    </div>
                                    <h3 class="card-titlde mb-1">Download Member</h3>
                                    <p>Download Member</p>
                                    <div class="row">
                                        <div class="col">
                                            <a href="#" class="btn btn-secondary">
                                                <ion-icon name="document-outline"></ion-icon>
                                                Dwonload Disini
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- * Slider -->





        <!-- app footer -->
        <div class="appFooter">
            <div class="footer-title">
                Laporan Online Billing
            </div>
        </div>
        <!-- * app footer -->

    </div>
    <!-- * App Capsule -->


    <?php 
    require DOC_ROOT_PATH . $this->config->item('botmenu');
    ?>

</body>

</html>